/**
 *******************************************************************************
 * @file    dpm32m0xx_dac.h
 *
 * @brief   Header file for DAC firmware driver.
 *
 * @author  DPM
 *
 * @version V1.0.0
 *
 * @date    2023-11-01
 *
 *******************************************************************************/

#ifndef __DPM32M0XX_DAC_H__
#define __DPM32M0XX_DAC_H__


#ifdef __cplusplus
extern "C" {
#endif

#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wpadded"
#endif


#include "dpm32m0xx.h"

#if defined (DPM32M08x) || defined (DPM32M05x) || defined (DPM32M03x)

/**
 ******************************************************************************
 * @brief DAC VREF_SEL enumeration.
 *****************************************************************************/
typedef enum
{
  DAC_VREF_AVDD           = 0x00UL,   /* DAC Vref select AVDD */
  DAC_VREF_BANDGAP        = 0x01UL    /* DAC Vref select Bandgap 2.4V */
} DAC_VrefSelEnum;

/* DAC VREF_SEL Check */
#define IS_VREF_SEL(x)  (((x)==DAC_VREF_BANDGAP)       ||\
                         ((x)==DAC_VREF_AVDD))

/**
 ******************************************************************************
 * @brief DAC Init Struct.
 *****************************************************************************/
typedef struct
{
  uint16_t        DAC_Data;     /* DAC Converted data */
  DAC_VrefSelEnum DAC_Vref;     /* DAC Vref select */
} DAC_InitTypeStruct;

/* Deinitializes and initialization functions. */
void                    DAC_DeInit(void);
void                    DAC_Init(DAC_InitTypeStruct *DAC_InitType);
void                    DAC_StructInit(DAC_InitTypeStruct *DAC_InitType);
void                    DAC_Cmd(FunctionalState NewState);

/* Enable or disable DAC functions. */
void                    DAC_Enable(void);
void                    DAC_Disable(void);

/* DAC configuration functions. */
void                    DAC_VrefSelect(DAC_VrefSelEnum DAC_VREF);
void                    DAC_SetData(uint16_t DAC_DATA);

#endif /* DPM32M08x || DPM32M05x || DPM32M03x */


#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic pop
#endif

#ifdef __cplusplus
}

#endif

#endif
