/**
 *******************************************************************************
 * @file    main.c
 *
 * @brief   Main program body.
 *
 * @author  DP
 *
 * @version V1.0.1
 *
 * @date    2024-11-11
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "main.h"
#include "adc_softtriggersingle.h"

/**
  * @addtogroup DPM32M036_LibSamples
  * @{
  */

/**
  * @addtogroup ADC 
  * @{
  */

/**
  * @addtogroup ADC SoftTriggerSingle
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/
uint32_t adcValue = 0;

/* Private functions ------------------------------------------------------------*/

/**
  * @brief  The program entry function.
  * @retval int
  */
int main(void)
{
  /* Configure the system clock */
  SystemClockInit();

  /* Configure the system tick */
  SystickInit();

  UART_ConfigInit();
  
  /* ADC SoftTriggerSingle Sample */
  ADC_SoftTriggerSingle_Sample();
  
  /* Infinite loop */
  while (1)
  {
    /* User code */
    ADC_StartConversion(ADC0);
    while(ADC_GetIntFlagStatus(ADC0, ADC_INT_FLAG_EOC) != SET);
    ADC_ClearIntFlag(ADC0, ADC_INT_FLAG_EOC);
    adcValue = ADC_GetSingleData(ADC0);  
    printf("Single value = %0.2fmV\r\n",(float)(adcValue) * 3300 / 4095);
    DelayMs(500);
  }
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
