/**
 *******************************************************************************
 * @file    lowpowerstop_lptimwakeup.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.1
 *
 * @date    2024-11-11
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "lowpowerstop_lptimwakeup.h"

/**
  * @addtogroup DPM32M036_LibSamples
  * @{
  */

/**
  * @addtogroup LowPower
  * @{
  */

/**
  * @addtogroup LowPower StopMode LPTIMWakeup
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   GPIO Config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void LPTIM_ConfigInit(void)
{
  /* Config LPTIM */
  LPTIM_InitTypeStruct LPTIM_InitType;
  LPTIM_InitType.LPTIM_PeriodValue = 32768 * 2;
  LPTIM_Init(&LPTIM_InitType);
 
  NVIC_SetPriority(LPTIM_IRQn, 2);
  NVIC_EnableIRQ(LPTIM_IRQn);
  LPTIM_IntCmd(ENABLE);

  /* Enable LPTIM */
  LPTIM_Cmd(ENABLE);
}

/**
 *******************************************************************************
 * @brief   LowPower Stop mode LPTIM Wakeup Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void LowPower_Stop_LPTIMWakeup_Sample(void)
{
  /* LPTIM Config */
  LPTIM_ConfigInit();
  
  /* Enable clock */
  RCC_Unlock();
  
  /* Enable the LSCLK in the stop mode. */
  RCC_StopModeFunctionCmd(RCC_STOP_FUNC_LSCLK, ENABLE);

  /* Enter the stop mode and wake up by the LPTIM event. */
  RCC_EnterLowPowerMode(RCC_LOW_POWER_MODE_STOP, RCC_LOW_POWER_ENTRY_WFE);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
