/**
 *******************************************************************************
 * @file    adc_bemfrsample.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "adc_bemfrsample.h"

/**
  * @addtogroup DPM32M030_LibSamples
  * @{
  */

/**
  * @addtogroup ADC
  * @{
  */

/**
  * @addtogroup ADC BEMFRSample
  * @{
  */

/* Private typedef --------------------------------------------------------------*/
GPIO_InitTypeStruct ADC_GPIO_InitStruct;
ADCCOM_InitTypeStruct ADCCOM_InitStruct;
ADCCOM_ChannelStruct ADCCOM_ChannelConfigStruct;
ADC_InitTypeStruct ADC_InitStruct;
ADC_ChannelStruct ADC_ChannelConfigStruct;

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/
uint32_t adcValue = 0;
float vol = 0;

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   ADC Config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ADC_Config(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_ADC, ENABLE);
  RCC_Lock();
  
  /* Config ADC common parameters */
  ADCCOM_StructInit(&ADCCOM_InitStruct);
  ADCCOM_InitStruct.AdcSpeed = 1;
  ADCCOM_InitStruct.Vref = ADC_VREF_AVDD;
  ADCCOM_InitStruct.ClkDiv = ADC_CLK_DIV1;
  ADCCOM_InitStruct.SampleTime0 = ADC_SAMPLE_TIME_64Cycles;
  ADCCOM_InitStruct.SampleTime1 = ADC_SAMPLE_TIME_64Cycles;
  ADCCOM_InitStruct.SampleAccuracy = ADC_Sample_Accuracy_12Bit;
  ADCCOM_Init(&ADCCOM_InitStruct);
  /* Config ADC channel common parameters  */
  ADCCOM_ChannelStructInit(&ADCCOM_ChannelConfigStruct);
  ADCCOM_ChannelConfigStruct.Channel = ADC_Channel_14;
  ADCCOM_ChannelConfigStruct.OversampleEnable = DISABLE;
  ADCCOM_ChannelConfigStruct.SampleTimeSel = ADC_SAMPLE_TIME_SEL0;
  ADCCOM_ChannelConfigStruct.Offset = 0;
  ADCCOM_ChannelConfig(&ADCCOM_ChannelConfigStruct);
  /* Config ADC channel */
  ADC_ChannelStructInit(&ADC_ChannelConfigStruct);
  ADC_ChannelConfigStruct.Channel = ADC_Channel_14;
  ADC_ChannelConfigStruct.DataAlign = ADC_DATA_ALIGN_RIGHT;
  ADC_ChannelConfigStruct.DataSign = ADC_DATA_UNSIGNED;
  ADC_ChannelConfig(ADC0, &ADC_ChannelConfigStruct);
  /* Config ADC0 */
  ADC_StructInit(&ADC_InitStruct);
  ADC_InitStruct.TrigMode = ADC_TRIG_SW_SINGLE_CONV;
  ADC_InitStruct.ContinueWait = ADC_CONTINUE_WAIT_CYCLE_0;
  ADC_InitStruct.SoftTrigChannel = ADC_Channel_14;
  ADC_Init(ADC0, &ADC_InitStruct);
}

/**
 *******************************************************************************
 * @brief   ADC BEMFRSample Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ADC_BEMFRSample_Sample(void)
{
  /* ADC config */
  ADC_Config();
  
  /* Enable ADC0 */
  ADC_Cmd(ADC0, ENABLE);
  DelayMs(1);
  /* Get BEMFR Voltage */
  ADC_StartConversion(ADC0);
  while(ADC_GetIntFlagStatus(ADC0, ADC_INT_FLAG_EOC) != SET);
  ADC_ClearIntFlag(ADC0, ADC_INT_FLAG_EOC);
  adcValue = ADC_GetSingleData(ADC0);
  vol = (float)(adcValue) * 3300 / 4096;
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
