/**
 *******************************************************************************
 * @file    lptim_counterinterrupt.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "lptim_counterinterrupt.h"

/**
  * @addtogroup DPM32M030_LibSamples
  * @{
  */

/**
  * @addtogroup demo
  * @{
  */

/**
  * @addtogroup demo
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   LPTIM IRQ Handler.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void LPTIM_IRQ_Handler(void)
{
  if(LPTIM_GetIntFlagStatus() == SET)
  {
    LPTIM_ClearIntFlag();
    GPIO_ToggleBit(GPIOA,GPIO_PIN_0);
  }
}
/**
 *******************************************************************************
 * @brief   GPIO output Config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void GPIO_OutoutConfig(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();

  /* Config OUTPUT mode */
  GPIO_InitTypeStruct GPIO_InitStruct;
  GPIO_StructInit(&GPIO_InitStruct);
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUTPUT;
  GPIO_InitStruct.GPIO_Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.GPIO_OType = GPIO_OTYPE_PP;
  GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_0;
  /* Init GPIO PA0 */
  GPIO_Init(GPIOA, &GPIO_InitStruct);
  
  /* Output low */
  GPIO_ResetBit(GPIOA,GPIO_PIN_0);  
}

/**
 *******************************************************************************
 * @brief   LSI Config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void LSI_Config(void)
{
  /* Enable LSI */
  RCC_Unlock();
  RCC_OscInitTypeStruct RCC_OscInitStruct;
  RCC_OscStructInit(&RCC_OscInitStruct);
  RCC_OscInitStruct.RCC_OscillatorType = RCC_OSCILLATOR_TYPE_LSI;
  RCC_OscInitStruct.RCC_LSIState = RCC_LSI_ON;
  RCC_OscConfig(&RCC_OscInitStruct);
  RCC_Lock();
}

/**
 *******************************************************************************
 * @brief   Demo Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void LPTIM_CounterInterrupt_Sample(void)
{
  /* Enable LSI*/
  LSI_Config();
  
  /* Config GPIO output */
  GPIO_OutoutConfig();
  
  /* Config LPTIM */
  LPTIM_InitTypeStruct LPTIM_InitType;
  LPTIM_InitType.LPTIM_PeriodValue = 3276;
  LPTIM_Init(&LPTIM_InitType);
  
  /* Enable interrtupt */
  NVIC_SetPriority(LPTIM_IRQn, 2);
  NVIC_EnableIRQ(LPTIM_IRQn);
  LPTIM_IntCmd(ENABLE);
  
  /* Enable LPTIM */
  LPTIM_Cmd(ENABLE);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
