/**
 *******************************************************************************
 * @file    dpm32m0xx_dbgmcu.h
 *
 * @brief
 *
 * @author  DPM
 *
 * @version V1.0.0
 *
 * @date    2023-11-01
 *
 *******************************************************************************/

#ifndef __DPM32M0XX_DBG_H__
#define __DPM32M0XX_DBG_H__


#ifdef __cplusplus
extern "C" {
#endif

#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wpadded"
#endif

#include "dpm32m0xx.h"

/**
 ******************************************************************************
 * @brief In debug mode, peripheral function enum.
 *****************************************************************************/
typedef enum
{
  DBG_PERIPH_WDG            = DBG_CFG_WDG_HALT_Msk,      /*!< WDG peripheral.   */
  DBG_PERIPH_TIM0           = DBG_CFG_TIM0_HALT_Msk,     /*!< TIM0 peripheral.  */
  DBG_PERIPH_TIM1           = DBG_CFG_TIM1_HALT_Msk,     /*!< TIM1 peripheral.  */
#if defined (DPM32M08x) || defined (DPM32M05x) || defined (DPM32M03x) || defined (DPM32M036)
  DBG_PERIPH_TIM2           = DBG_CFG_TIM2_HALT_Msk,     /*!< TIM2 peripheral.  */
#endif /* DPM32M08x || DPM32M05x || DPM32M03x || DPM32M036 */
#if defined (DPM32M08x) || defined (DPM32M05x)
  DBG_PERIPH_TIM3           = DBG_CFG_TIM3_HALT_Msk,     /*!< TIM3 peripheral.  */
  DBG_PERIPH_TIM4           = DBG_CFG_TIM4_HALT_Msk,     /*!< TIM4 peripheral.  */
  DBG_PERIPH_TIM5           = DBG_CFG_TIM5_HALT_Msk,     /*!< TIM5 peripheral.  */
#endif
  DBG_PERIPH_CCT0           = DBG_CFG_CCT0_HALT_Msk,     /*!< CCT0 peripheral.  */
#if defined (DPM32M08x) || defined (DPM32M05x) || defined (DPM32M03x)
  DBG_PERIPH_CCT1           = DBG_CFG_CCT1_HALT_Msk,     /*!< CCT1 peripheral.  */
#endif
  DBG_PERIPH_LPTIM          = DBG_CFG_LPTIM_HALT_Msk,    /*!< LPTIM peripheral. */
  DBG_PERIPH_EPWM           = DBG_CFG_EPWM_HALT_Msk      /*!< EPWM peripheral.  */
} DBG_PeriphEnum;

/**
 ******************************************************************************
 * @brief In debug mode, peripheral function state enum.
 *****************************************************************************/
typedef enum
{
  DBG_STATE_CONTINUE = 0x00UL,
  DBG_STATE_PAUSE
} DBG_PeriphStateEnum;

/**
 *******************************************************************************
 * @brief  Enable or disable the peripheral function in debug mode.
 ******************************************************************************/
#define DBG_WDG_DISABLE()     (DBG->CFG &= ~DBG_CFG_WDG_HALT_Msk)
#define DBG_TIM0_DISABLE()    (DBG->CFG &= ~DBG_CFG_TIM0_HALT_Msk)
#define DBG_TIM1_DISABLE()    (DBG->CFG &= ~DBG_CFG_TIM1_HALT_Msk)
#if defined (DPM32M08x) || defined (DPM32M05x) || defined (DPM32M03x) || defined (DPM32M036)
#define DBG_TIM2_DISABLE()    (DBG->CFG &= ~DBG_CFG_TIM2_HALT_Msk)
#endif /* DPM32M08x || DPM32M05x || DPM32M03x || DPM32M036 */
#if defined (DPM32M08x) || defined (DPM32M05x)
#define DBG_TIM3_DISABLE()    (DBG->CFG &= ~DBG_CFG_TIM3_HALT_Msk)
#define DBG_TIM4_DISABLE()    (DBG->CFG &= ~DBG_CFG_TIM4_HALT_Msk)
#define DBG_TIM5_DISABLE()    (DBG->CFG &= ~DBG_CFG_TIM5_HALT_Msk)
#endif
#define DBG_CCT0_DISABLE()    (DBG->CFG &= ~DBG_CFG_CCT0_HALT_Msk)
#if defined (DPM32M08x) || defined (DPM32M05x) || defined (DPM32M03x)
#define DBG_CCT1_DISABLE()    (DBG->CFG &= ~DBG_CFG_CCT1_HALT_Msk)
#endif
#define DBG_LPTIM_DISABLE()   (DBG->CFG &= ~DBG_CFG_LPTIM_HALT_Msk)
#define DBG_EPWM_DISABLE()    (DBG->CFG &= ~DBG_CFG_EPWM_HALT_Msk)



#define DBG_WDG_ENABLE()      (DBG->CFG |= DBG_CFG_WDG_HALT_Msk)
#define DBG_TIM0_ENABLE()     (DBG->CFG |= DBG_CFG_TIM0_HALT_Msk)
#define DBG_TIM1_ENABLE()     (DBG->CFG |= DBG_CFG_TIM1_HALT_Msk)
#if defined (DPM32M08x) || defined (DPM32M05x) || defined (DPM32M03x) || defined (DPM32M036)
#define DBG_TIM2_ENABLE()     (DBG->CFG |= DBG_CFG_TIM2_HALT_Msk)
#endif /* DPM32M08x || DPM32M05x || DPM32M03x || DPM32M036 */
#if defined (DPM32M08x) || defined (DPM32M05x)
#define DBG_TIM3_ENABLE()     (DBG->CFG |= DBG_CFG_TIM3_HALT_Msk)
#define DBG_TIM4_ENABLE()     (DBG->CFG |= DBG_CFG_TIM4_HALT_Msk)
#define DBG_TIM5_ENABLE()     (DBG->CFG |= DBG_CFG_TIM5_HALT_Msk)
#endif
#define DBG_CCT0_ENABLE()     (DBG->CFG |= DBG_CFG_CCT0_HALT_Msk)
#if defined (DPM32M08x) || defined (DPM32M05x) || defined (DPM32M03x)
#define DBG_CCT1_ENABLE()     (DBG->CFG |= DBG_CFG_CCT1_HALT_Msk)
#endif
#define DBG_LPTIM_ENABLE()    (DBG->CFG |= DBG_CFG_LPTIM_HALT_Msk)
#define DBG_EPWM_ENABLE()     (DBG->CFG |= DBG_CFG_EPWM_HALT_Msk)



/* Deinitializes and cmd functions. */
void                    DBG_DeInit(void);
void                    DBG_PeriphCmd(DBG_PeriphEnum DBG_Periph, FunctionalState NewState);
void                    DBG_PeriphConfig(DBG_PeriphEnum DBG_Periph, DBG_PeriphStateEnum NewState);

#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic pop
#endif

#ifdef __cplusplus
}

#endif

#endif /* __DPM32M0XX_DBG_H__ */
